/*
 * Decompiled with CFR 0.152.
 */
package wrappers;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.UUID;
import javax.sql.DataSource;

public class JdbcInterface {
    static Hashtable<String, DataSource> dst = null;
    boolean DEBUG = false;
    boolean CatisSchema = false;
    String Errmsg = "No error";
    Connection conn = null;
    DatabaseMetaData dbmd = null;
    Statement stmt = null;
    PreparedStatement pstmt = null;
    ResultSet rs = null;
    ResultSetMetaData rsmd = null;

    public JdbcInterface() {
        this(false);
    }

    public JdbcInterface(boolean bl) {
        this.DEBUG = bl;
    }

    protected void SetErrmsg(Exception exception) {
        if (this.DEBUG) {
            System.out.println(exception.getMessage());
        }
        this.Errmsg = exception.toString();
    }

    public String GetErrmsg() {
        String string = this.Errmsg;
        this.Errmsg = "No error";
        return string;
    }

    protected void CheckURL(String string, String string2) throws Exception {
        if (string == null) {
            throw new Exception("URL cannot be null");
        }
        String[] stringArray = string.split(":", 3);
        if (!stringArray[0].equals("jdbc") || stringArray[1] == null) {
            throw new Exception("Invalid URL");
        }
        if (string2 != null && !stringArray[1].equals(string2)) {
            throw new Exception("Wrong URL for this wrapper");
        }
        this.CatisSchema = stringArray[1].equals("mysql") || stringArray[1].equals("mariadb");
    }

    public int JdbcConnect(String[] stringArray, int n, boolean bl) {
        int n2 = 0;
        if (this.DEBUG) {
            System.out.println("In JdbcInterface: driver=" + stringArray[0]);
        }
        try {
            if (this.DEBUG) {
                System.out.println("In try block");
            }
            if (stringArray[0] != null && !stringArray[0].isEmpty()) {
                if (this.DEBUG) {
                    System.out.println("Loading class" + stringArray[0]);
                }
                Class.forName(stringArray[0]);
            }
            if (this.DEBUG) {
                System.out.println("URL=" + stringArray[1]);
            }
            this.CheckURL(stringArray[1], null);
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (stringArray[2] != null && !stringArray[2].isEmpty()) {
                if (this.DEBUG) {
                    System.out.println("user=" + stringArray[2] + " pwd=" + stringArray[3]);
                }
                this.conn = DriverManager.getConnection(stringArray[1], stringArray[2], stringArray[3]);
            } else {
                this.conn = DriverManager.getConnection(stringArray[1]);
            }
            if (this.DEBUG) {
                System.out.println("Connection " + this.conn.toString() + " established");
            }
            this.dbmd = this.conn.getMetaData();
            this.stmt = this.GetStmt(n, bl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.SetErrmsg(classNotFoundException);
            n2 = -1;
        }
        catch (SQLException sQLException) {
            this.SetErrmsg(sQLException);
            n2 = -2;
        }
        catch (Exception exception) {
            this.SetErrmsg(exception);
            n2 = -3;
        }
        return n2;
    }

    protected Statement GetStmt(int n, boolean bl) throws SQLException, Exception {
        Statement statement = null;
        statement = bl ? this.conn.createStatement(1004, 1007) : this.conn.createStatement(1003, 1007);
        if (this.DEBUG) {
            System.out.println("Statement type = " + statement.getResultSetType() + " concurrency = " + statement.getResultSetConcurrency());
        }
        if (this.DEBUG) {
            System.out.println("Default fetch size = " + statement.getFetchSize());
        }
        if (n != 0) {
            statement.setFetchSize(n);
            if (this.DEBUG) {
                System.out.println("New fetch size = " + statement.getFetchSize());
            }
        }
        return statement;
    }

    public int CreatePrepStmt(String string) {
        int n = 0;
        try {
            this.pstmt = this.conn.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            this.SetErrmsg(sQLException);
            n = -1;
        }
        catch (Exception exception) {
            this.SetErrmsg(exception);
            n = -2;
        }
        return n;
    }

    public void SetStringParm(int n, String string) {
        try {
            this.pstmt.setString(n, string);
        }
        catch (Exception exception) {
            this.SetErrmsg(exception);
        }
    }

    public void SetIntParm(int n, int n2) {
        try {
            this.pstmt.setInt(n, n2);
        }
        catch (Exception exception) {
            this.SetErrmsg(exception);
        }
    }

    public void SetShortParm(int n, short s) {
        try {
            this.pstmt.setShort(n, s);
        }
        catch (Exception exception) {
            this.SetErrmsg(exception);
        }
    }

    public void SetBigintParm(int n, long l) {
        try {
            this.pstmt.setLong(n, l);
        }
        catch (Exception exception) {
            this.SetErrmsg(exception);
        }
    }

    public void SetFloatParm(int n, float f) {
        try {
            this.pstmt.setFloat(n, f);
        }
        catch (Exception exception) {
            this.SetErrmsg(exception);
        }
    }

    public void SetDoubleParm(int n, double d) {
        try {
            this.pstmt.setDouble(n, d);
        }
        catch (Exception exception) {
            this.SetErrmsg(exception);
        }
    }

    public void SetTimestampParm(int n, Timestamp timestamp) {
        try {
            this.pstmt.setTimestamp(n, timestamp);
        }
        catch (Exception exception) {
            this.SetErrmsg(exception);
        }
    }

    public void SetUuidParm(int n, String string) {
        try {
            UUID uUID = string == null ? null : (string.isEmpty() ? UUID.randomUUID() : UUID.fromString(string));
            this.pstmt.setObject(n, uUID);
        }
        catch (Exception exception) {
            this.SetErrmsg(exception);
        }
    }

    public int SetNullParm(int n, int n2) {
        int n3 = 0;
        try {
            this.pstmt.setNull(n, n2);
        }
        catch (Exception exception) {
            this.SetErrmsg(exception);
            n3 = -1;
        }
        return n3;
    }

    public int ExecutePrep() {
        int n = -3;
        if (this.pstmt != null) {
            try {
                n = this.pstmt.executeUpdate();
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
                n = -1;
            }
            catch (Exception exception) {
                this.SetErrmsg(exception);
                n = -2;
            }
        }
        return n;
    }

    public boolean ClosePrepStmt() {
        boolean bl = false;
        if (this.pstmt != null) {
            try {
                this.pstmt.close();
                this.pstmt = null;
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
                bl = true;
            }
            catch (Exception exception) {
                this.SetErrmsg(exception);
                bl = true;
            }
        }
        return bl;
    }

    public int JdbcDisconnect() {
        int n = 0;
        if (this.stmt != null) {
            try {
                if (this.DEBUG) {
                    System.out.println("Cancelling statement");
                }
                this.stmt.cancel();
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
                ++n;
            }
        }
        if (this.rs != null) {
            try {
                if (this.DEBUG) {
                    System.out.println("Closing result set");
                }
                this.rs.close();
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
                n = 2;
            }
        }
        if (this.stmt != null) {
            try {
                if (this.DEBUG) {
                    System.out.println("Closing statement");
                }
                this.stmt.close();
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
                n += 4;
            }
        }
        this.ClosePrepStmt();
        if (this.conn != null) {
            try {
                if (this.DEBUG) {
                    System.out.println("Closing connection");
                }
                this.conn.close();
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
                n += 8;
            }
        }
        if (this.DEBUG) {
            System.out.println("All closed");
        }
        return n;
    }

    public int GetMaxValue(int n) {
        int n2 = 0;
        try {
            switch (n) {
                case 1: {
                    n2 = this.dbmd.getMaxColumnsInTable();
                    break;
                }
                case 2: {
                    n2 = this.dbmd.getMaxCatalogNameLength();
                    break;
                }
                case 3: {
                    n2 = this.dbmd.getMaxSchemaNameLength();
                    break;
                }
                case 4: {
                    n2 = this.dbmd.getMaxTableNameLength();
                    break;
                }
                case 5: {
                    n2 = this.dbmd.getMaxColumnNameLength();
                }
            }
        }
        catch (Exception exception) {
            this.SetErrmsg(exception);
            n2 = -1;
        }
        return n2;
    }

    public String GetQuoteString() {
        String string = null;
        try {
            string = this.dbmd.getIdentifierQuoteString();
        }
        catch (SQLException sQLException) {
            this.SetErrmsg(sQLException);
        }
        return string;
    }

    public int GetColumns(String[] stringArray) {
        int n = -1;
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            this.rs = this.CatisSchema ? this.dbmd.getColumns(stringArray[1], null, stringArray[2], stringArray[3]) : this.dbmd.getColumns(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
            if (this.rs != null) {
                this.rsmd = this.rs.getMetaData();
                n = this.rsmd.getColumnCount();
            }
        }
        catch (SQLException sQLException) {
            this.SetErrmsg(sQLException);
        }
        return n;
    }

    public int GetTables(String[] stringArray) {
        int n = -1;
        String[] stringArray2 = null;
        if (stringArray[3] != null) {
            stringArray2 = new String[]{stringArray[3]};
        }
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            this.rs = this.CatisSchema ? this.dbmd.getTables(stringArray[1], null, stringArray[2], stringArray2) : this.dbmd.getTables(stringArray[0], stringArray[1], stringArray[2], stringArray2);
            if (this.rs != null) {
                this.rsmd = this.rs.getMetaData();
                n = this.rsmd.getColumnCount();
            }
        }
        catch (SQLException sQLException) {
            this.SetErrmsg(sQLException);
        }
        return n;
    }

    public int Execute(String string) {
        int n = 0;
        if (this.DEBUG) {
            System.out.println("Executing '" + string + "'");
        }
        try {
            boolean bl = this.stmt.execute(string);
            if (!bl) {
                n = this.stmt.getUpdateCount();
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            if (this.DEBUG) {
                System.out.println("Query '" + string + "' executed: n = " + n);
            }
        }
        catch (SQLException sQLException) {
            this.SetErrmsg(sQLException);
            n = -1;
        }
        catch (Exception exception) {
            this.SetErrmsg(exception);
            n = -2;
        }
        return n;
    }

    public int GetResult() {
        int n = 0;
        try {
            this.rs = this.stmt.getResultSet();
            if (this.rs != null) {
                this.rsmd = this.rs.getMetaData();
                n = this.rsmd.getColumnCount();
                if (this.DEBUG) {
                    System.out.println("Result set has " + this.rsmd.getColumnCount() + " column(s)");
                }
            }
        }
        catch (SQLException sQLException) {
            this.SetErrmsg(sQLException);
            n = -1;
        }
        catch (Exception exception) {
            this.SetErrmsg(exception);
            n = -2;
        }
        return n;
    }

    public int ExecuteQuery(String string) {
        int n = 0;
        if (this.DEBUG) {
            System.out.println("Executing query '" + string + "'");
        }
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            this.rs = this.stmt.executeQuery(string);
            this.rsmd = this.rs.getMetaData();
            n = this.rsmd.getColumnCount();
            if (this.DEBUG) {
                System.out.println("Query '" + string + "' executed successfully");
                System.out.println("Result set has " + this.rsmd.getColumnCount() + " column(s)");
            }
        }
        catch (SQLException sQLException) {
            this.SetErrmsg(sQLException);
            n = -1;
        }
        catch (Exception exception) {
            this.SetErrmsg(exception);
            n = -2;
        }
        return n;
    }

    public int ExecuteUpdate(String string) {
        int n = 0;
        if (this.DEBUG) {
            System.out.println("Executing update query '" + string + "'");
        }
        try {
            n = this.stmt.executeUpdate(string);
            if (this.DEBUG) {
                System.out.println("Update Query '" + string + "' executed: n = " + n);
            }
        }
        catch (SQLException sQLException) {
            this.SetErrmsg(sQLException);
            n = -1;
        }
        catch (Exception exception) {
            this.SetErrmsg(exception);
            n = -2;
        }
        return n;
    }

    public int ReadNext() {
        if (this.rs != null) {
            try {
                return this.rs.next() ? 1 : 0;
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
                return -1;
            }
        }
        return 0;
    }

    public boolean Fetch(int n) {
        if (this.rs != null) {
            try {
                return this.rs.absolute(n);
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
                return false;
            }
        }
        return false;
    }

    public String ColumnName(int n) {
        if (this.rsmd == null) {
            System.out.println("No result metadata");
        } else {
            try {
                return this.rsmd.getColumnLabel(n);
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
            }
        }
        return null;
    }

    public int ColumnType(int n, String string) {
        if (this.rsmd == null) {
            System.out.println("No result metadata");
        } else {
            try {
                if (n == 0) {
                    n = this.rs.findColumn(string);
                }
                return this.rsmd.getColumnType(n);
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
            }
        }
        return 666;
    }

    public String ColumnDesc(int n, int[] nArray) {
        if (this.rsmd == null) {
            System.out.println("No result metadata");
            return null;
        }
        try {
            nArray[0] = this.rsmd.getColumnType(n);
            nArray[1] = this.rsmd.getPrecision(n);
            nArray[2] = this.rsmd.getScale(n);
            nArray[3] = this.rsmd.isNullable(n);
            return this.rsmd.getColumnLabel(n);
        }
        catch (SQLException sQLException) {
            this.SetErrmsg(sQLException);
            return null;
        }
    }

    public String StringField(int n, String string) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                return n > 0 ? this.rs.getString(n) : this.rs.getString(string);
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
            }
        }
        return null;
    }

    public int IntField(int n, String string) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                return n > 0 ? this.rs.getInt(n) : this.rs.getInt(string);
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
            }
        }
        return 0;
    }

    public long BigintField(int n, String string) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                BigDecimal bigDecimal = n > 0 ? this.rs.getBigDecimal(n) : this.rs.getBigDecimal(string);
                return bigDecimal != null ? bigDecimal.longValue() : 0L;
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
            }
        }
        return 0L;
    }

    public double DoubleField(int n, String string) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                return n > 0 ? this.rs.getDouble(n) : this.rs.getDouble(string);
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
            }
        }
        return 0.0;
    }

    public float FloatField(int n, String string) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                return n > 0 ? this.rs.getFloat(n) : this.rs.getFloat(string);
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
            }
        }
        return 0.0f;
    }

    public boolean BooleanField(int n, String string) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                return n > 0 ? this.rs.getBoolean(n) : this.rs.getBoolean(string);
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
            }
        }
        return false;
    }

    public int DateField(int n, String string) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                Date date = n > 0 ? this.rs.getDate(n) : this.rs.getDate(string);
                return date != null ? (int)(date.getTime() / 1000L) : 0;
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
            }
        }
        return 0;
    }

    public int TimeField(int n, String string) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                Time time = n > 0 ? this.rs.getTime(n) : this.rs.getTime(string);
                return time != null ? (int)(time.getTime() / 1000L) : 0;
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
            }
        }
        return 0;
    }

    public int TimestampField(int n, String string) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                Timestamp timestamp = n > 0 ? this.rs.getTimestamp(n) : this.rs.getTimestamp(string);
                return timestamp != null ? (int)(timestamp.getTime() / 1000L) : 0;
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
            }
        }
        return 0;
    }

    public Object ObjectField(int n, String string) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                return n > 0 ? this.rs.getObject(n) : this.rs.getObject(string);
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
            }
        }
        return null;
    }

    public String UuidField(int n, String string) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                Object object = n > 0 ? this.rs.getObject(n) : this.rs.getObject(string);
                return object.toString();
            }
            catch (SQLException sQLException) {
                this.SetErrmsg(sQLException);
            }
        }
        return null;
    }

    public int GetDrivers(String[] stringArray, int n) {
        int n2 = 0;
        ArrayList<Driver> arrayList = Collections.list(DriverManager.getDrivers());
        int n3 = Math.min(n, arrayList.size());
        for (int i = 0; i < n3; ++i) {
            Driver driver = (Driver)arrayList.get(i);
            stringArray[n2++] = driver.getClass().getName();
            stringArray[n2++] = driver.getMajorVersion() + "." + driver.getMinorVersion();
            stringArray[n2++] = driver.jdbcCompliant() ? "Yes" : "No";
            stringArray[n2++] = driver.toString();
        }
        return n3;
    }
}

